#ifndef OLED_H
#define OLED_H

#include "p33FJ64GP802.h"
#include "integer.h"
#include "types.h"
#include "lcd16x2.h"

#define XLIMIT 15             // screen dimensions
#define YLIMIT 7
#define COLOUR0		0x2233
#define COLOUR1		0x7722
#define COLOUR2		0x3344
#define COLOUR3		0x4433
#define COLOUR4		0xF000
#define COLOUR5		0x3F30

extern void delayMs(int);
void initOLED(void);
void setBackgroundColourOLED(unsigned int);
void setColourOLED(unsigned int);
void advanceCursorOLED(void);
void clsOLED(void);
void setFontSizeOLED(BYTE);
void writecOLED(BYTE);
void setCursorOLED(char, char);
void writeStringOLED(char*);
void killOLED(void);
BYTE disFix(BYTE);
void disafreeOLED(BYTE);
void disaOLED(char, char, BYTE);
void diswordfreeOLED(unsigned int);
void disdwordfreeOLED(unsigned long);
int iitoa(int, char*, int, int);
void disdecfreeOLED(int, int);
void disdecOLED(char, char, int);
void writeStringAtOLED(char, char, char*);
void writeStringPaddedOLED(char*, int);
void writeStringAtPaddedOLED(char, char, char*, int);
void disFUnsignedOLED(char, char, double, int, int, int);

#endif
